package de.mse.uebung6.aufgabe1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class MovieRangeSearch {

   private TreeMap<Integer, List<Movie>> map;

   // Konstruktor
   public MovieRangeSearch() {
      map = new TreeMap<Integer, List<Movie>>();
   }

   public void insertMovieForYear(int year, Movie movie) {
      List<Movie> movies = map.get(year);

      if (movies == null) {
         // Es gibt noch keinen Film im Jahr = 'year'
         LinkedList<Movie> entry = new LinkedList<Movie>();
         entry.add(movie);
         map.put(year, entry);
      } else {
         // Es gab schon filme im Jahr = 'year'
         movies.add(movie);
      }
   }

   public Collection<Movie> getMoviesBetweenYears(int fromYear, int toYear) {
      Map<Integer, List<Movie>> submap = map.subMap(fromYear, toYear);
      Collection<List<Movie>> values = submap.values();

      ArrayList<Movie> result = new ArrayList<Movie>();
      for (List<Movie> movies : values) {
         result.addAll(movies);
      }

      return result;
   }

   // Dieser Client verwendet Ihre Implementierung
   public static void main(String[] args) {
      MovieRangeSearch movieSearch = new MovieRangeSearch();

      // Filme einfuegen
      List<Movie> movies = Movie.readMoviesFromFile("mse/src/de/mse/uebung6/aufgabe1/movies.txt");
      for (Movie m : movies) {
         movieSearch.insertMovieForYear(m.year, m);
      }

      // Bereichszugriff
      Collection<Movie> list = movieSearch.getMoviesBetweenYears(1950, 1959);

      // Ausgabe
      System.out.println("Filme zwischen 1950 und 1959:");
      for (Movie m : list) {
         System.out.println(m);
      }
   }
}